function psi = shapefun(x,L)
% funzioni di interpolazione per trave Eulero-Bernoulli
p1 = 1 - x/L;
p2 = x/L;
p3 = 1 - 3*x^2/L^2 + 2*x^3/L^3;
p4 = x - 2*x^2/L + x^3/L^2;
p5 = 3*x^2/L^2 - 2*x^3/L^3;
p6 = -x^2/L + x^3/L^2;
psi = [p1 0  0  p2 0  0
       0  p3 p4 0  p5 p6];
   
    