P = 10000;

% nodi
x = [0 2 4 10 12 14];
y = [0 5 10 12 7 2];

% elementi
el = [1 2
      2 3
      3 4
      4 5
      5 6
      2 5];

% carichi sui nodi
Px = [0 P 0 0 0 0];
Py = [0 0 P P 0 0];
M = [0 0 0 0 0 0];

% vincoli:  nodo, gdl vincolato (1 = u, 2 = v, 3 = fi)
D = [1 1
     1 2
     6 1
     6 2];
 

Ne = size(el,1);    % numero elementi
Nn = length(x);     % numero nodi
Ndof = 3*Nn;        % numero gradi di libert

E = 210e9 * ones(Ne,1);
A = 2.5E-5 * ones(Ne,1);
J = 1.2E-5 * ones(Ne,1);


hf = figure(1); % disegna struttura
quiver(x,y,Px,Py,.3,'r')
for e = 1:Ne
    line(x(el(e,:)),y(el(e,:)))
end
p = reshape([Px;Py;M],[Ndof,1]);

q = fem_solve(x,y,el,p,D,E,A,J);

figure(2)
s = 10;
fem_plot(x,y,q,el,s);
xlim([-1 13])
ylim([0 12]);
axis equal
grid on

