function q = fem_solve(x,y,el,p,D,E,A,J)
% calcola spostamenti nodali travatura
% x, y = coordinate nodi
% el = matrice 2 x Ne con nodi di appoggio elementi
% p = vettore forze esterne applicate ai nodi
% D = nodi vincolati (matrive Nv x 2) contenente nodi e gdl vincolati
% E, A, J caratteristiche meccaniche elementi

Ne = size(el,1);
Nn = length(x);
Ndof = 3*Nn;

K = zeros(Ndof,Ndof);
% assemblaggio matrice di rigidezza
for e=1:Ne
    O = zeros(2,Nn);
    O(1,el(e,1)) = 1;
    O(2,el(e,2)) = 1;
    O = kron(O,eye(3));
    th = atan2(y(el(e,2))-y(el(e,1)),x(el(e,2))-x(el(e,1)));
    T = [cos(th) sin(th) 0
          -sin(th) cos(th) 0
          0 0 1];
    T = kron(eye(2),T);
    K = K + O' * T' * stfmat(x(el(e,:)),y(el(e,:)), E(e),A(e),J(e)) * T * O;
end

gdl_V = zeros(size(D,1),1);
for k=1:size(D,1)
    gdl_V(k) = 3*(D(k,1)-1) + D(k,2);
end
v = ones(Ndof,1);
v(gdl_V) = 0;
gdl_L = find(v);

KLL = K(gdl_L,gdl_L);
KLV = K(gdl_L,gdl_V);
KVL = K(gdl_V,gdl_L);
KVV = K(gdl_V,gdl_V);

pL = p(gdl_L);

% impone vincoli perfetti (senza cedimenti)
qV = zeros(size(gdl_V));

% calcola spostamento gdl liberi
qL = inv(KLL)*(pL - KLV*qV);

% calcola reazioni vincolari
r = KVL*qL + KVV*qV;

% ricostruisce vettore gdl
q = zeros(Ndof,1);
q(gdl_L) = qL;
q(gdl_V) = qV;
