function [] = fem_plot(x,y,q,el,s)
% disegna travatura deformata
Ne = size(el,1);
Nn = length(x);
Ndof = 3*Nn;


u = q(1:3:Ndof);
v = q(2:3:Ndof);
fi = q(3:3:Ndof);

newplot
for e = 1:Ne
    line(x(el(e,:)),y(el(e,:)),'color','b');

    O = zeros(2,Nn);
    O(1,el(e,1)) = 1;
    O(2,el(e,2)) = 1;
    O = kron(O,eye(3));
    th = atan2(y(el(e,2))-y(el(e,1)),x(el(e,2))-x(el(e,1)));
    T = [cos(th) sin(th) 0
          -sin(th) cos(th) 0
          0 0 1];
    T = kron(eye(2),T);
    qe = T * O * q;
    L = sqrt((x(el(e,2))-x(el(e,1)))^2 + (y(el(e,2))-y(el(e,1)))^2);
    Np = 100;
    qq = zeros(2,Np);
    xx = zeros(1,Np);
    yy = zeros(1,Np);
    for k=1:Np
        xx(k) = x(el(e,1)) + (k-1)*(x(el(e,2))-x(el(e,1))) / (Np-1);
        yy(k) = y(el(e,1)) + (k-1)*(y(el(e,2))-y(el(e,1))) / (Np-1);
        
        qq(:,k) = T(1:2,1:2)' * shapefun(L/(Np-1)*(k-1),L)*qe;
    end
    line(xx + qq(1,:)*s, yy + qq(2,:)*s,'color','r')
end
